
float3 amg_specular_common(
    float3 pixel_in_direction, 
    float3 pixel_irradiance, 
    float3 amg_normalWorld, 
    float3 amg_vecWorldRayDirection, 
    float shinness)
{
    /* Old specular lighting */
    /*
    float3 reflection = reflect(-pixel_in_direction, amg_normalWorld);
    float specular = saturate(dot(reflection, amg_vecWorldRayDirection));
    specular = pow(specular, shinness);
    return float4(pixel_irradiance * specular, 1);
    */

    /* Max specular lighting. */
    float3 half_angle_vector = normalize(-amg_vecWorldRayDirection - pixel_in_direction);
    float n_dot_l = dot(amg_normalWorld, -pixel_in_direction);
    float n_dot_h = dot(amg_normalWorld, half_angle_vector);
    float4 litV = lit(n_dot_l, n_dot_h, shinness);
    float3 result = pixel_irradiance * litV.z;
    result = saturate(result);
    return result;
}
